/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SYNCHRO_COMPONENT_H
#define SYNCHRO_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <errno.h>
	   }

#include <libpandora/thread.h>
#include <libpandora/component.h>

#define NB_MUTEXES	4
#define NB_SEMAPHORES	4

class SynchroComponent : public Component {
 private:
  static Mutex mutex[NB_MUTEXES];
  int  mindex;
  bool locked;

public:
  component_init(SynchroComponent, 1);
  inline SynchroComponent(void);
  virtual ~SynchroComponent(void) { }

  virtual bool add(Packet *p);
  virtual void setup(void);
  virtual void cleanup(void);
};

SynchroComponent::SynchroComponent(void) 
  : mindex(0), locked(false)
{
  registerOption("index",  &mindex);
}

class SemaphoreComponent : public Component {
 private:
  static Semaphore sema[NB_SEMAPHORES];
  int  mindex;
  bool wait, signal;
  int  factor;
  int  count;

public:
  component_init(SemaphoreComponent, 1);
  inline SemaphoreComponent(void);
  virtual ~SemaphoreComponent(void) { }

  virtual bool add(Packet *p);
  virtual void setup(void);
  virtual void cleanup(void);
};

SemaphoreComponent::SemaphoreComponent(void) 
  : mindex(0), wait(false), signal(false), factor(1), count(0)
{
  registerOption("index",     &mindex);
  registerOption("wait",      &wait);
  registerOption("signal",    &signal);
  registerOption("factor",    &factor);
}

#endif /* SYNCHRO_COMPONENT_H */
