/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

extern "C" {
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>
	   }

#include "shellinputcomponent.h" 
#include <libpandora/conf/wait.h>
#include <pandora_components/valuepacket.h> 

component_export(ShellInputComponent,, IntValuePacket|TextValuePacket);

ShellInputComponent::ShellInputComponent(void)
  : shell("/bin/sh"), cmd(NULL), num(false)
{ 
  registerOption("shell", &shell); 
  registerOption("cmd", &cmd); 
  registerOption("num", &num); 
}

int ShellInputComponent::init(void) 
{
  if (shell == NULL) {
    pandora_warning("invalid null shell");
    return ERROR_FILENO;
  }

  if (cmd == NULL) {
    pandora_warning("invalid null command");
    return ERROR_FILENO;
  }
  
  shell_cmd[0] = shell;
  shell_cmd[1] = "-c";
  shell_cmd[2] = cmd;
  shell_cmd[3] = NULL;

  return VOID_FILENO;
}

bool ShellInputComponent::process(void) 
{
  int fd[2];
  pid_t pid;  
  int n, len;

  if (pipe(fd) < 0) {
    pandora_pwarning("pipe");
    return false;
  }

  switch (pid= fork()) {
  case -1:
    pandora_pwarning("fork");
    return true;
  
  case 0:
    close(fd[0]);
    if (dup2(fd[1], STDOUT_FILENO) < 0) pandora_perror("dup2");

    execve(shell, shell_cmd, NULL);
    pandora_pwarning("exec");
    _exit(1);

  default:
    close(fd[1]);

    if (waitpid(-1, NULL, WUNTRACED) < 0) {
      pandora_pwarning("wait");
      return true;
    }
    
    len = 0;
    n = 0;

    while ((n = read(fd[0], output + len, sizeof(output) - len)) > 0) 
      len += n;
    close(fd[0]);

    output[len]='\0';
    while(isspace(output[len-1])) output[--len] = '\0';

    if (num) {
      push(new IntValuePacket(atoi(output)));
    } else {
      push(new TextValuePacket(output));
    }
  }

  return false;
}

void ShellInputComponent::finish(void) 
{
}
