/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <iostream>
#include <iomanip>
#include <pandora_components/rpctranspacket.h>
#include <pandora_components/rpcpacket.h>
#include <pandora_components/ippacket.h>
#include <libpandora/serialize.h>
#include <libpandora/timeval.h>

packet_export(RPCTransPacket, RPCPacket);

RPCTransPacket::RPCTransPacket(RPCPacket *c, RPCPacket *r) :
    type(undefined), rtt(-1), length(-1)
{
  if (c == NULL || r == NULL) {
    cleanPacket(c);
    cleanPacket(r);
    return;
  }
  
  type = match;

  c->status = r->status;
  c->accepted = r->accepted;

  rtt = diffTimeStamp(r->timeStamp, c->timeStamp);
  length = c->length + r->length;
  timeStamp = c->timeStamp;

  packetSetUp(c);
  cleanPacket(r);
}

RPCTransPacket::RPCTransPacket(RPCPacket *pkt) :
    type(undefined), rtt(-1), length(-1)
{
  if (pkt == NULL) return;
  type = (pkt->isQuery()) ? request : response;

  timeStamp = pkt->timeStamp;

  packetSetUp(pkt);
}

RPCTransPacket::RPCTransPacket(const RPCTransPacket& x) : 
  Packet(x), type(x.type), rtt(x.rtt), length(x.length) 
{
}

RPCTransPacket& RPCTransPacket::operator= (const RPCTransPacket& x) 
{
  Packet::operator=(x);
  type = x.type; rtt = x.rtt; length = x.length;
  return *this;
}

void RPCTransPacket::print(ostream *f) 
{
  locatePacket(RPCPacket, rpcp, this);
  locatePacket(IPPacket, ipp, rpcp);

  if (type != match) {
    pandora_notice("unmatched RPC call/reply");
    if (rpcp != NULL) rpcp->print(f);
    return;
  }

  *f << timeStamp << ' '
     << setw(6) << setfill(' ') << rtt << ' '
     << ipp->src << ' ' << ipp->dst << ' '
     << length << ' '
     << "RPC " 
     << ntohl(rpcp->prog) << '.' << ntohl(rpcp->vers)
     << "::" << ntohl(rpcp->proc) << ' ';
  if (rpcp->accepted) *f << "OK ";
  else *f << "FAIL ";
  *f << endl;
}

size_t RPCTransPacket::write(char *str, size_t maxlen, int level)
{
  size_t count = 0;

  serialVar(type);
  serialVar(rtt);
  serialVar(length);

  return count;
}

size_t RPCTransPacket::read(const char *str, int level)
{
  size_t count = 0;

  unserialVar(type);
  unserialVar(rtt);
  unserialVar(length);

  return count;
}
