/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef REQUEST_PACKET_H
#define REQUEST_PACKET_H

#include <libpandora/global.h>

#include <libpandora/packet.h>
#include <libpandora/packetdata.h>


class RequestPacket : public Packet {
public:
  u_int32_t 	addr;
  u_short 	port;
  bool		tcp;
  packetData	req;

public:
  packet_init(RequestPacket, 1);

  inline RequestPacket(u_int32_t a, u_short p, const timeval *t = NULL);
  inline RequestPacket(const RequestPacket& x);
  inline RequestPacket& operator= (const RequestPacket& x);
  virtual ~RequestPacket(void) { }

  virtual void print(ostream *f) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

RequestPacket::RequestPacket(u_int32_t a, u_short p, const timeval *t) 
  : addr(a), port(p), tcp(true) 
{
  if (t != NULL) timeStamp = *t;
  else setTimeStamp();
}

RequestPacket::RequestPacket(const RequestPacket& x) 
  : Packet(x), addr(x.addr), port(x.port), tcp(x.tcp), req(x.req) 
{ 
}

RequestPacket& RequestPacket::operator= (const RequestPacket& x) 
{
  Packet::operator=(x);
  addr = x.addr; port = x.port; tcp = x.tcp; req = x.req;
  return *this;
}

#endif /* REQUEST_PACKET_H */
