/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <ctype.h>
	   }

#include "readlinecomponent.h"
#include <pandora_components/valuepacket.h>

component_export(ReadLineComponent,, TextValuePacket);

int ReadLineComponent::init(void)
{
  if (name == NULL) {
    f = stdin;
    return STDIN_FILENO;
  } 
  
  if ((f = fopen(name, "r")) == NULL) {
    pandora_warning(name << ": " << strerror(errno));
    return ERROR_FILENO;
  }
  return fileno(f);
}

bool ReadLineComponent::process(void)
{
  if (f == NULL) return true;

  fgets(buf, 8192, f);
  if (feof(f)) {
    if (keep) pause();
    else return true;
  }
  if (*buf == '\0') return true;
  int len = strlen(buf);
  while(isspace(*(buf+len-1))) --len;
  buf[len] = '\0';
  TextValuePacket *vpp = new TextValuePacket(buf);
  push(vpp);

  return false;
}

void ReadLineComponent::finish(void)
{
  if (f != NULL) {
    if (f != stdin) fclose(f);
    f = NULL;
  }
}
