/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef RATER_COMPONENT_H
#define RATER_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
	   }

#include <libpandora/packet.h>
#include <libpandora/component.h>

class RaterComponent : public Component {
private:
  float rate;
  int   interval;
  int 	size;
  timeval target;

  int seen;

public:
  component_init(RaterComponent, 1);
  inline RaterComponent(void);
  virtual ~RaterComponent(void) {}

  virtual bool add(Packet *);
  virtual void setup(void);
  virtual void cleanup(void);
};


RaterComponent::RaterComponent(void) : 
  rate(0.0), interval(0), size(1), seen(0) 
{
  registerOption("rate", &rate);
  registerOption("interval", &interval);
  registerOption("size", &size);
  target.tv_sec = 0;
}

#endif /* RATER_COMPONENT_H */
