/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/usleep.h>
	   }

#include "ratercomponent.h"
#include <libpandora/timeval.h>

component_export(RaterComponent, Packet, Packet);

bool RaterComponent::add(Packet *pkt) 
{
  push(pkt);
  if (++seen == size) {
    incTimeStamp(target, interval);
    sleep_until(target);
    seen = 0;
  }
  return false;
}

void RaterComponent::setup(void)
{
  if (rate > 0.0) {
    interval = (int)((float)1000 / rate);
  }

  if (target.tv_sec == 0) gettimeofday(&target, NULL);
} 

void RaterComponent::cleanup(void)
{
  target.tv_sec = 0; 
} 
