/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef POLYNOTIF_COMPONENT_H
#define POLYNOTIF_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <libpandora/sched_manager.h>

class Packet;

class PolyNotifComponent : public Component { 
private:
  int window;
  sched_manager_t smgr;

public:
  component_init(PolyNotifComponent, 1);
  inline  PolyNotifComponent(void);
  virtual ~PolyNotifComponent(void) { }

  virtual bool add(Packet *p); 
  virtual void setup(void);
  virtual void cleanup(void);
};

PolyNotifComponent::PolyNotifComponent(void) 
  : window(86400)
{ 
  registerOption("window", &window);
}
#endif /* POLYNOTIF_COMPONENT_H */

