/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

#include "polynotifcomponent.h" 
#include <pandora_components/valuepacket.h> 
#include <pandora_components/fseventpacket.h> 
#include <libpandora/timersupervisor.h>

component_export(PolyNotifComponent, TextValuePacket+, FSEventPacket);

struct delayed_t {
  Component 	*comp;
  Packet 	*pkt;
};

static void delayed_push(delayed_t *d, time_t t)
{
  //pandora_debug("pushing    " << *(d->pkt) << " @" << t);
  d->comp->push(d->pkt);
  __DELETE(d);
}

static void delayed_cleanup(delayed_t *d, time_t t)
{
  cleanPacket(d->pkt);
  __DELETE(d);
}

bool PolyNotifComponent::add(Packet *pkt) 
{
  locatePacket0(TextValuePacket, valuep, pkt);
  if (valuep == NULL) return_clean(pkt);

  char *line = (valuep->val).data();
  char *end;
  time_t expire = strtol(line, &end, 10);

  if (expire == 0) {
    pandora_warning("cannot parse timestamp");
    cleanPacket(pkt);
    return false;
  }

  time_t tout = expire - timerSupervisor->getTime();
  
  if (tout > window) {
    cleanPacket(pkt);
    return false;
  }

  if (end == NULL || *end == '\0') {
    pandora_warning("cannot find url");
    cleanPacket(pkt);
    return false;
  }

  FSEventPacket *fsep = new FSEventPacket(end);
  cleanPacket(pkt);
  
  CERR(LOG_DEBUG) << "scheduling @" << expire << ": ";
  pandora_debug(*fsep);

  delayed_t *d = new delayed_t;
  d->comp = this;
  d->pkt =  fsep;

  smgr.schedule(sched_task_t((sched_task_func_t *)&delayed_push, 
			     (sched_task_func_t *)&delayed_cleanup, 
			     d),
		tout,
		false);
  return false;
} 

void PolyNotifComponent::setup(void) 
{
  pandora_assert(timerSupervisor != NULL);
  smgr.setScheduler(timerSupervisor->getScheduler());
}

void PolyNotifComponent::cleanup(void) 
{
  smgr.cleanup();
}
