/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef PCAP_HANDLER_COMPONENT_H
#define PCAP_HANDLER_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <pcap.h>
	   }

#include <libpandora/inputcomponent.h>
#include <pandora_components/ippacket.h>
#include <libpandora/thread.h>
  
struct printer {
  pcap_handler f;
  int type;
};

class PcapHandlerComponent : public InputComponent {
private:
  int recv, drops;
  pcap_t *pd;
  pcap_handler handler;
  int pcount;
  u_char *userdata;
  char *cmdbuf;
  char *device;
  char *RFileName;
  int snaplen;
  int promisc;
  int to_ms;

  static Mutex mx;
  bool locked;

  IPPacket *ipp;

public:
  component_init(PcapHandlerComponent, 1);
  PcapHandlerComponent(void);
  virtual ~PcapHandlerComponent(void) { cleanPacket(ipp); }

  virtual int  init(void);
  virtual bool process(void);
  virtual void finish(void);

  bool updateStats(void);
  void printStats(void);

private:
  void resetStats(void) { recv = drops = 0; }

  static printer printers[];
  static void ether_if_print(u_char *, const pcap_pkthdr *, const u_char *);
  static void sll_if_print(u_char *, const pcap_pkthdr *, const u_char *);
  static void null_if_print(u_char *, const pcap_pkthdr *, const u_char *);
  static void ppp_if_print(u_char *, const pcap_pkthdr *, const u_char *);
  static void ppp_bsdos_if_print(u_char *, const pcap_pkthdr *, const u_char *);
  static void raw_if_print(u_char *, const pcap_pkthdr *, const u_char *);
  static pcap_handler lookup(int type);

  inline void dispatch(const u_char *, u_int, const timeval &);
};

void PcapHandlerComponent::dispatch(const u_char *data, u_int len,
				    const timeval &ts)
{
#if 0
  if (ipp == NULL) ipp = new IPPacket(data, len, ts);
  else ipp->init(data, len, ts);

  ipp->refer();
  push(ipp);
  ipp->release();

  if (ipp->inUse()) {
    (ipp->_data).doCopy();
    ipp = NULL;
  }
#else
  push(new IPPacket(data, len, ts));
#endif
}

#endif /* PCAP_HANDLER_COMPONENT_H */
