/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef NOTIFICATION_PACKET_H
#define NOTIFICATION_PACKET_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  int type;
  void *data;
} event_t;

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
#include <libpandora/global.h>

#include <libpandora/packet.h>


class NotificationPacket : public Packet {
private:
  event_t 	event;

public:
  packet_init(NotificationPacket, 1);

public:
  NotificationPacket(int op, void *data, const timeval *t = NULL);
  NotificationPacket(const NotificationPacket& x);
  NotificationPacket& operator= (const NotificationPacket& x);
  virtual ~NotificationPacket(void) {}

  event_t *getEvent(void) { return &event; }

  virtual void print(ostream *f) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

#endif /* __cplusplus */

#endif /* NOTIFICATION_PACKET_H */
