/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */



#include <libpandora/global.h>                                                 

#include <iostream>
#include <libpandora/packet.h>
#include <pandora_components/multipacket.h> 
#include <libpandora/timeval.h>

packet_export(MultiPacket, Packet);

MultiPacket::MultiPacket(int sz)
{
  elements.init(sz);
  setTimeStamp();
}

MultiPacket::MultiPacket(Packet *p0, Packet *p1)
{
  elements.init(2);
  elements[0] = p0;
  elements[1] = p1;
  setTimeStamp();
}

MultiPacket::MultiPacket(const MultiPacket& x) 
  : Packet(x)
{
  int n = x.elements.size();
  elements.init(n);
  for (int i = 0; i < n; ++i) 
    elements[i] = (x.elements.get_const(i))->clone();
}

MultiPacket& MultiPacket::operator= (const MultiPacket& x) 
{
  Packet::operator=(x);
  int n = x.elements.size();
  elements.init(n);
  for (int i = 0; i < n; ++i) 
    elements[i] = (x.elements.get_const(i))->clone();
  return *this;
}

MultiPacket::~MultiPacket(void)
{
  clear();
}

void MultiPacket::print(ostream *f) 
{
  *f << timeStamp << "\t[multi] " ;
  *f  << endl;
}

size_t MultiPacket::write(char *str, size_t maxlen, int level)
{
  size_t count = 0;

  serialVar(elements);

  return count;
}

size_t MultiPacket::read(const char *str, int level)
{
  size_t count = 0;

  unserialVar(elements);

  return count;
}

void  MultiPacket::store(Packet *pkt, int pos)
{
  cleanPacket(elements[pos]);
  elements[pos] = pkt;
}

void  MultiPacket::clear(void)
{
  for (int i = 0; i < size(); ++i) 
    cleanPacket(elements[i]);
}
