/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef MULTI_INPUT_COMPONENT_H
#define MULTI_INPUT_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/unistd.h>
#include <assert.h>
	   }

#include <libpandora/inputcomponent.h>
#include <libpandora/pandora_limits.h>
#include <libpandora/thread.h>

class Packet;
class Select;

class MultiInputComponent : public InputComponent {
private:
  Mutex mx;
  InputComponent *next_inputs[MAX_BRANCHES];
  int nb_succs;

  InputComponent *next_thr_inputs[MAX_BRANCHES];
  int nb_thr_succs;

  Select *iselect;

public:
  component_init(MultiInputComponent, 1);
  MultiInputComponent(void);
  virtual ~MultiInputComponent(void) { }

  virtual int  init(void);
  virtual bool process(void);  
  virtual void finish(void);
  virtual void halt(void);

private:
  void join_thr_input(InputComponent *, int);
};

#endif /* MULTI_INPUT_COMPONENT_H */
