/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef MAILER_COMPONENT_H
#define MAILER_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <stdio.h>
}

#include <libpandora/outputcomponent.h>

class Packet;

class MailerComponent : public OutputComponent { 
private: 
  char 		localhost[256];
  char		inbuf[BUFSIZ], outbuf[BUFSIZ];
  in_addr_t 	addr;
  char		from_def[256];

  char 		*smtp; 
  int 		port; 
  char 		*to; 
  char 		*from; 
  char 		*subject; 

public:
  component_init(MailerComponent, 1);
  MailerComponent(void);
  virtual ~MailerComponent(void);

  virtual bool add(Packet *p); 
  virtual void setup(void);
  virtual void cleanup(void);

private:
  const char *canon_addr(const char *);
  int read_response(FILE *in);
  bool format_message(const char *, const char *, const char *, const char *,
		      char *, int);
};

#endif /* MAILER_COMPONENT_H */

