/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

#include "magiccomponent.h" 

#include <pandora_components/tcppacket.h>
#include <pandora_components/ippacket.h>

#include <libpandora/complex_option.h>
#include <libpandora/magic.h>

component_export(MagicComponent, TCPPacket+,);

class magic_option : public complex_option {
public:
  bool set(const char *f) { 
    if (f == NULL) return false; 
    magic_init(f); 
    pandora_debug("magic init ok");
    return true; 
  }
  void *getReference(void) { return NULL; }
  export_option(magic_option);
};

static void *f;

MagicComponent::MagicComponent(void)
{ 
  registerStaticOption(magic_option, "file", &f);  
}

MagicComponent::~MagicComponent(void)
{
}

bool MagicComponent::add(Packet *pkt) 
{
  locatePacket0(TCPPacket, tcpp, pkt);
  locatePacket0(IPPacket,  ipp,  tcpp);
  if (ipp == NULL) return_clean(pkt);

  char *type = magic_match((u_char *) ipp->data(), ipp->dlength());
  
  if (type != NULL) pandora_debug(type << ": " << *tcpp);
  else pandora_debug(*tcpp << ipp->data());

  cleanPacket(pkt);

  return false;
}
