/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "ipfragswitchcomponent.h"

component_export(IPFragSwitchComponent, IPPacket, IPPacket);

int IPFragSwitchComponent::_switch(Packet *obj) 
{
  IPPacket *ipp = static_cast<IPPacket *>(obj);

  if ((ipp->_data).isEmpty()){
    pandora_warning("invalid IP packet, skipping");
    return -1;
  }
    
  return ((ipp->offset & 0x3fff) ? 1 : 0);
}
