/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <pandora_components/ippacket.h>
#include "ipanoncomponent.h"
#include <libpandora/anonymize.h>
#include <libpandora/encoding.h>
#include <libpandora/common_options.h>

component_export(IPAnonComponent, IPPacket+, Packet);

IPAnonComponent::IPAnonComponent(void) 
  : key(NULL), IPreject(NULL), IPgroup(NULL) 
{
  registerStaticOption(template_option<ipreject>, "ipreject", &IPreject);
  registerStaticOption(template_option<ipgroup>, "ipgroup", &IPgroup);
  registerStaticOption(template_option<text>, "key", &key);
}
  
bool IPAnonComponent::add(Packet* pkt)    
{
  locatePacket0(IPPacket, ipp, pkt);

  if (ipp != NULL) {
    if ((IPreject != NULL)
	&& (IPreject->find(ipp->src.s_addr)
	    || IPreject->find(ipp->dst.s_addr))) {
      cleanPacket(pkt);
      return false;
    }
    
    if (IPgroup != NULL) {
      ipp->group = IPgroup->find(ipp->src.s_addr);
    }

    if (key != NULL) {
      hash_ip((in_addr_t *)&(ipp->src.s_addr), *key); // Solaris uses long u_int!
      hash_ip((in_addr_t *)&(ipp->dst.s_addr), *key);
    }
  }
  
  push(pkt);
  return false;
}
