/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef IDENTITY_COMPONENT_H
#define IDENTITY_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <libpandora/error.h>

class NullComponent : public Component {
public:
  component_init(NullComponent, 1);
  NullComponent(void) { }
  virtual ~NullComponent(void) { }

  virtual bool add(Packet *p) { push(p); return false; }
};

class IdentityComponent : public Component {
private:
  int dtest;
  bool ret;
  Set<in_addr_t> *s;

public:
  component_init(IdentityComponent, 1);
  IdentityComponent(void);
  virtual ~IdentityComponent(void);

  virtual bool add(Packet *p);
  virtual void setup(void);
  virtual void cleanup(void);

  virtual bool query(const text &arg, MultiValue *);

  static void printme(const char *s, void *i);
};

#endif /* IDENTITY_COMPONENT_H */
