/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <iomanip>
#include <iostream>
#include <pandora_components/icptranspacket.h>
#include <pandora_components/icppacket.h>
#include <pandora_components/ippacket.h>
#include <libpandora/serialize.h>
#include <libpandora/timeval.h>

packet_export(ICPTransPacket, ICPPacket);

ICPTransPacket::ICPTransPacket(ICPPacket *q, ICPPacket *r)
  : type(undefined), rtt(-1), length(-1)
{
  if (q == NULL || r == NULL) {
    cleanPacket(q);
    cleanPacket(r);
    return;
  }
  
  type = match;

  rtype = r->type;
  rtt = ((compareTimeStamp(r->timeStamp, q->timeStamp) > 0) 
	 ? diffTimeStamp(r->timeStamp, q->timeStamp)
	 : 0);
  
  length = q->length + r->length;
  timeStamp = q->timeStamp;    

  packetSetUp(q);
  cleanPacket(r);
}

ICPTransPacket::ICPTransPacket(ICPPacket *pkt) 
  : type(undefined), rtt(-1), length(-1)
{
  if (pkt == NULL) return;
  type = (pkt->isQuery()) ? request : response;

  timeStamp = pkt->timeStamp;

  packetSetUp(pkt);
}

ICPTransPacket::ICPTransPacket(const ICPTransPacket& x) 
  : Packet(x), type(x.type), rtype(x.rtype), rtt(x.rtt), length(x.length) 
{
}

ICPTransPacket&ICPTransPacket:: operator= (const ICPTransPacket& x) 
{
  Packet::operator=(x);
  type = x.type; rtype = x.rtype; rtt = x.rtt; length = x.length;
  return *this;
}

void ICPTransPacket::print(ostream *f) 
{
  locatePacket(ICPPacket, 	icpp, 	this);
  locatePacket(IPPacket,	ipp,	icpp);

  if(type != match) {
    if (icpp != NULL) icpp->print(f); 
    return;
  } else {
    *f << timeStamp << ' '
       << setw(6) << setfill(' ') << rtt << ' '
       << ipp->src << ' ' << ipp->dst << ' '
       << length << ' '
       << icpp->url << ' '
       << "ICP/";

    switch(rtype) {
    case ICP_OP_HIT: case ICP_OP_HIT_OBJ: 	*f << "HIT ";  	 	break;
    case ICP_OP_MISS: 				*f << "MISS ";  	break;
    case ICP_OP_ERR:   	 	 	 	*f << "ERR ";   	break;
    case ICP_OP_DENIED: 	 	 	*f << "DENIED ";  	break;
    default:  	 	 	 	 	*f << "?? ";  	 	break;
    }
  }

  *f << endl;
}

size_t ICPTransPacket::write(char *str, size_t maxlen, int level) 
{
  size_t count = 0;

  serialVar(type);
  serialVar(rtype);
  serialVar(rtt);
  serialVar(length);

  return count;
}

size_t ICPTransPacket::read(const char *str, int level) 
{
  size_t count = 0;

  unserialVar(type);
  unserialVar(rtype);
  unserialVar(rtt);
  unserialVar(length);

  return count;
}
