/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "icpcacheswitchcomponent.h"
#include <pandora_components/ippacket.h>

component_export(ICPCacheSwitchComponent, 
		 CacheTransPacket|ICPPacket, 
		 CacheTransPacket|ICPPacket);

int ICPCacheSwitchComponent::_switch(Packet *pkt) 
{
  locatePacket(IPPacket, ipp, pkt);
  if (ipp == NULL) {
    cleanPacket(pkt);
    return -1;
  }

  symbol_id_t id = pkt->getID();

  if (id == CacheTransPacket::packet_id) {
    CacheTransPacket *ctp = static_cast<CacheTransPacket *>(pkt);
    if ((ctp->type == CacheTransPacket::miss)
	&& proxies.includes((ipp->dst).s_addr)) {
      ctp->type = CacheTransPacket::hit_sibling;
    }
    return (ctp->isHit() ? 1 : 0);  
  } else if (id == ICPPacket::packet_id) {
    proxies.add((ipp->dst).s_addr);
    return 2;
  }
  
  return -1;
}
