/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <iostream>
#include <iomanip>
#include <pandora_components/icmptranspacket.h>
#include <pandora_components/icmppacket.h>
#include <pandora_components/ippacket.h>
#include <libpandora/timeval.h>
#include <libpandora/serialize.h>

packet_export(ICMPTransPacket, ICMPPacket);

ICMPTransPacket::ICMPTransPacket(ICMPPacket *c, ICMPPacket *r) 
  : type(undefined), rtt(-1), length(-1)
{
  if (c == NULL || r == NULL) {
    cleanPacket(c);
    cleanPacket(r);
    return;
  }
  
  type = match;
  rtt = diffTimeStamp(r->timeStamp, c->timeStamp);
  length = c->length + r->length;
  timeStamp = c->timeStamp;
  
  packetSetUp(c);
  cleanPacket(r);
}


ICMPTransPacket::ICMPTransPacket(ICMPPacket *pkt) 
  : type(undefined), rtt(-1), length(-1)
{
  if (pkt == NULL) return;
  type = (pkt->isQuery()) ? request : response;

  timeStamp = pkt->timeStamp;

  packetSetUp(pkt);
}


ICMPTransPacket::ICMPTransPacket(const ICMPTransPacket& x) 
  : Packet(x), type(x.type), rtt(x.rtt), length(x.length) 
{
}

ICMPTransPacket& ICMPTransPacket::operator= (const ICMPTransPacket& x) 
{
  Packet::operator=(x);
  type = x.type; rtt = x.rtt; length = x.length;
  return *this;
}

void ICMPTransPacket::print(ostream *f) 
{
  locatePacket(ICMPPacket, 	icmpp, 	this);
  locatePacket(IPPacket, 	ipp, 	icmpp);

  if (type != match) {
    if (icmpp != NULL) icmpp->print(f);
    return;
  }

  *f << icmpp->timeStamp << ' '
     << setw(6) << setfill(' ') << rtt << ' '
     << ipp->src << ' ' << ipp->dst << ' '
     << length << ' '
     << "[ping] "
     << icmpp->id << ' '
     << icmpp->data.icmp_seq << ' ';
  *f << endl;
}

size_t ICMPTransPacket::write(char *str, size_t maxlen, int level)
{
  size_t count = 0;

  serialVar(type);
  serialVar(rtt);
  serialVar(length);

  return count;
}

size_t ICMPTransPacket::read(const char *str, int level)
{
  size_t count = 0;

  unserialVar(type);
  unserialVar(rtt);
  unserialVar(length);

  return count;
}
