/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef ICMP_PACKET_H
#define ICMP_PACKET_H

#include <libpandora/global.h>

#include <libpandora/packet.h>
#include <pandora_components/icmp.h>

#define ICMP_UNDEF (ICMP_MAXTYPE+1)

class IPPacket;


class ICMPPacket : public Packet {
public:
  u_char 	type;
  u_char 	code;
  icmp_t 	data;
  u_int32_t 	id;
  u_short 	length;
  
public:
  packet_init(ICMPPacket, 1);


  ICMPPacket(IPPacket *);
  ICMPPacket(const ICMPPacket& x);
  ICMPPacket& operator= (const ICMPPacket& x);
  virtual ~ICMPPacket(void) { }
  
  virtual void print(ostream *) ;
  inline bool isQuery(void) const;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

bool ICMPPacket::isQuery(void) const
{
  return ((type == ICMP_ECHO) 
	  || (type == ICMP_TSTAMP)
	  || (type == ICMP_IREQ));

}

#endif /* ICMP_PACKET_H */
