/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef HTTP_TRANS_PACKET_H
#define HTTP_TRANS_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <netinet/in.h>
#include <netinet/in_systm.h>
}

#include <libpandora/packet.h>
#include <libpandora/text.h>
#include <libpandora/serialize.h>

class HTTPPacket;


class HTTPTransPacket : public Packet {
public:
  enum httpt_t     { undefined = -1, request, response, match };
  enum httpt_pos_t { alone = 0, before, after, sibling, matched };

public:
  httpt_t	type;
  httpt_pos_t	pos;
  int 		rtt;
  int 		lat;
  int 		reqhlen;
  int 		reqmlen;
  int 		resphlen;
  int 		respmlen;
  time_t 	date_s;
  int 		rversion;

public:
  packet_init(HTTPTransPacket, 1);

  HTTPTransPacket(HTTPPacket *, HTTPPacket *);
  HTTPTransPacket(HTTPPacket *);
  HTTPTransPacket(const HTTPTransPacket& x);
  HTTPTransPacket& operator=(const HTTPTransPacket& x);
  virtual ~HTTPTransPacket(void) { }

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

  virtual void print(ostream *) ;

  inline bool reqOK(void) { return ((type == match) || (type == request)); }
  inline bool respOK(void) { return ((type == match) || (type == response)); }
  inline bool matchOK(void) { return (type == match); }

private:
  void ntohm(void);
};

serialEnum(HTTPTransPacket::httpt_t);
serialEnum(HTTPTransPacket::httpt_pos_t);
  
#endif /* HTTP_TRANS_PACKET_H */
