/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef HTTP_STAT_COMPONENT_H
#define HTTP_STAT_COMPONENT_H

#include <libpandora/global.h>

#include <iostream>
#include <queue>
#include <pandora_components/httptranspacket.h>
#include <libpandora/component.h>

class HTTPStatComponent : public Component {
private:
  long latency;
  int state;
  int low, high;
  int size;
  queue<int> Q;

public:

  component_init(HTTPStatComponent, 1);
  HTTPStatComponent(void) : latency(0), 
    state(0), low(0), high(0), size(10) {
    registerOption("low", &low);
    registerOption("high", &high);
    registerOption("size", &size);
  }

  virtual ~HTTPStatComponent(void) {}  
  
  virtual bool add(Packet *p);

  virtual void cleanup(void);

private:
  int check(void);
};

#endif /* HTTP_STAT_COMPONENT_H */
