/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "httpstatcomponent.h"
#include <pandora_components/notificationpacket.h>
#include <pandora_components/ippacket.h>

component_export(HTTPStatComponent, HTTPTransPacket, NotificationPacket);

bool HTTPStatComponent::add(Packet *pkt) 
{
  HTTPTransPacket *httpp = static_cast<HTTPTransPacket *>(pkt);
  int op = -1;

  int lat = httpp->lat;

  if (lat <= 0) goto finished;

  latency += lat;
  Q.push(lat);

  if (Q.size() > (size_t) size) {
    int old_lat = Q.front();
    Q.pop();
    latency -= old_lat;
  } else {
    goto finished;
  }
  
  pandora_assert(Q.size() == (size_t)size);

  op = check();
  
  if (op != state) {
    locatePacket(IPPacket, ipp, httpp);
    if (ipp == NULL) return false;
    state = op;
    NotificationPacket *npp = 
      new NotificationPacket(op, (void *)(ipp->dst.s_addr),
			     &httpp->timeStamp);
    push(npp);
  }

 finished:
  cleanPacket(httpp);
  return false;
}

int HTTPStatComponent::check(void) 
{
  if ((u_long) latency < (u_long) (low * size)) return 1;
  if ((u_long) latency > (u_long) (high * size)) return 0;
  return state;
}

void HTTPStatComponent::cleanup(void) 
{
  while(Q.size() > 0) Q.pop();
  latency = 0;
  low = high = 0;
  state = 0;
}
