/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "httpmarkcomponent.h"
#include <pandora_components/httptranspacket.h>
#include <pandora_components/httppacket.h>
#include <pandora_components/ippacket.h>
#include <libpandora/common_options.h>

component_export(HTTPMarkComponent, HTTPTransPacket+, Packet);

bool HTTPMarkComponent::add(Packet *pkt) 
{
  locatePacket0(HTTPTransPacket, httptp, pkt);
  locatePacket(HTTPPacket,       httpp,  httptp);
  locatePacket(IPPacket,         ipp,    httpp);

  if (ipp == NULL) {
    cleanPacket(pkt);
    return false;
  }

  if (httptp->pos != HTTPTransPacket::alone) {
    push(pkt);
    return false;
  }

  if (httpp->absolute && !proxies.includes((ipp->dst).s_addr))
    proxies.add((ipp->dst).s_addr);

  httptp->pos = (httpp->absolute
		 ? (((httpp->via > 0) || (proxies.includes((ipp->src).s_addr)))
		    ? HTTPTransPacket::sibling
		    : HTTPTransPacket::before)
		 : HTTPTransPacket::after);

  push(pkt);
  return false;
}
