/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef GUILE_INPUT_H
#define GUILE_INPUT_H

#include <libpandora/global.h>

#include <iostream>
#include <libpandora/inputcomponent.h>
#include <libpandora/error.h>
  
class ControlPacket;

class GuileInputComponent : public InputComponent {
private:
  ControlPacket *resp;
  char *cmd;
  bool shell;

public:

  component_init(GuileInputComponent, 1);
  GuileInputComponent(void);
  virtual ~GuileInputComponent(void) { cleanup(); }

  virtual int  init(void);
  virtual bool process(void);
  virtual void finish(void) { }

  virtual bool pull(Packet *pkt);
  virtual void cleanup(void);

  static bool sendControl(ControlPacket *);
  static bool getStatus(void);

  template <class T> static bool response(T&);

  static bool connect(const char *host, int port);

private:
  static GuileInputComponent *guileComp;
  static ControlPacket *getResp(void);
};

template <class T>
bool GuileInputComponent::response(T &obj)
{
  ControlPacket *cp = getResp();
  if (cp == NULL) return false;
  bool ret;
  cp->readParam(obj);
  return true;
}


#endif /* GUILE_INPUT_COMPONENT_H */



