/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "guileinputcomponent.h"
#include <pandora_components/controlpacket.h>
#include <libpandora/stackdesc.h>
#include <libpandora/pandora.h>

#include "guile_pandora.h"
#include "guile_pandora_proc.h"
#include "guile_pandora_types.h"

component_export(GuileInputComponent,, Packet);

GuileInputComponent *GuileInputComponent::guileComp = NULL;

GuileInputComponent::GuileInputComponent(void) 
  : resp(NULL), cmd(NULL), shell(true)
{
  registerOption("shell", &shell);
  registerOption("exec", &cmd);
  if (guileComp == NULL) guileComp = this;
}

void GuileInputComponent::cleanup(void)
{
  cleanPacket(resp);
  if (guileComp == this) guileComp = NULL;
}

static void guile_inner_main(void *closure, int argc, char **argv)
{
#ifdef HAVE_LIBGUILE_H
  scm_init_pguile_module();
  scm_eval_0str("(use-modules (pandora))");
  scm_eval_0str("(define-module (guile) :use-module (pandora))");
  scm_eval_0str("(define-module (guile-user) :use-module (pandora))");
  
  scm_shell (argc, argv);
#endif
}

int GuileInputComponent::init(void) 
{
#ifdef HAVE_LIBGUILE_H
  if (shell) {
    int argc = 0;
    char *argv[6];
    
    argv[argc++] = "[GuileInputComponent]";
    if (cmd != NULL) {
      argv[argc++] = "-c";
      argv[argc++] = cmd;
    }
    argv[argc] = NULL;
    
    scm_boot_guile(argc, argv, guile_inner_main, 0);
    return 0;
  } else {
    this->refer();
    return 0;
  }
#else
  pandora_error("you need the guile library (libguile) to use this component");
  return ERROR_FILENO;
#endif
}

bool GuileInputComponent::process(void) 
{
  if (!shell) pause();
  return true;
}
  
bool GuileInputComponent::sendControl(ControlPacket *cp)
{
  if (guileComp == NULL) {
    pandora_warning("pandora module is not initialized");
    return false;
  }
  guileComp->push(cp);
  return true;
}

bool GuileInputComponent::getStatus(void)
{
  ControlPacket *cp = getResp();
  if (cp == NULL) return false;
  bool ret;
  cp->readParam(ret);
  cleanPacket(guileComp->resp);
  return ret;
}

bool GuileInputComponent::connect(const char *host, int port)
{
  bool status = true;
  status = pandora->setOption(guileComp->compStack->getHandle(), 
			      "NetWriterComponent", 
			      "host", 
			      host)
    & status;
  status = pandora->setOption(guileComp->compStack->getHandle(),
			      "NetWriterComponent", 
			      "port", 
			      port)
    & status;
  return status;
}

bool GuileInputComponent::pull(Packet *pkt)
{
  locatePacket0(ControlPacket, cp, pkt);
  if (cp == NULL) return false;
  if (guileComp->resp != NULL) cleanPacket(guileComp->resp);

  if (cp != pkt) {
    guileComp->resp = static_cast<ControlPacket *>(cp->clone());
    cleanPacket(pkt);
  } else {
    guileComp->resp = cp;
  }

  return true;
}

ControlPacket *GuileInputComponent::getResp(void)
{
  if (guileComp == NULL) return NULL;
  return guileComp->resp;
}
