/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef GUILE_TYPES_H
#define GUILE_TYPES_H

#include <libpandora/global.h>

#include "guile_pandora.h"
#include <libpandora/optionentry.h>
#include <libpandora/stackentry.h>
#include <libpandora/compentry.h>
#include <libpandora/optionentry.h>
#include <libpandora/multivalue.h>
#include <libpandora/pipe.h>
#include <libpandora/map.h>

extern Map<text, SCM> packet_pipes;

class Packet;
class ControlPacket;

typedef Pipe<Packet *> packet_pipe_t;

struct pandora_packet_pipe {
  text		id;
  packet_pipe_t *pkt_pipe;
};

extern long option_tag, comp_tag, stack_tag;
extern long packet_pipe_tag;

extern void pandora_init_types(void);

extern SCM pandora_make_stack(void);
extern SCM se2scm(const StackEntry *se);
extern void scm2se(SCM s_pstack, StackEntry *se);
extern SCM take_se(StackEntry *se);
extern StackEntry *scm2se(SCM s_pstack);

extern SCM pandora_make_component(void);
extern SCM pandora_make_macro(void);
extern SCM ce2scm(const CompEntry *ce);
extern void scm2ce(SCM s_pcomp, CompEntry *ce);
extern SCM take_ce(CompEntry *ce);
extern CompEntry *scm2ce(SCM s_pcomp);

extern SCM pandora_make_option(void);
extern SCM oe2scm(const OptionEntry *oe);
extern void scm2oe(SCM s_poption, OptionEntry *oe);
extern SCM take_oe(OptionEntry *oe);
extern OptionEntry *scm2oe(SCM s_poption);

extern SCM pandora_make_packet_pipe(SCM);
extern SCM pandora_get_pipe(const text &);
extern packet_pipe_t *pandora_get_pipe_ptr(SCM);

extern SCM pandora_parse(SCM);
extern SCM pandora_print(SCM);

extern SCM mv2scm(const MultiValue &);
extern void scm2mv(SCM, MultiValue &);
extern MultiValue::multi_value_t pandora_get_value_type(SCM);

extern inline void scm2text(SCM, text &);
extern inline SCM text2scm(const text &);
extern inline SCM take_text(text &);

#define SCM_POPTIONP(x)	(SCM_NIMP(x) && (SCM_CAR(x) == option_tag))
#define SCM_PCOMPP(x)	(SCM_NIMP(x) && (SCM_CAR(x) == comp_tag))
#define SCM_PSTACKP(x)	(SCM_NIMP(x) && (SCM_CAR(x) == stack_tag))
#define SCM_PPIPEP(x)	(SCM_NIMP(x) && (SCM_CAR(x) == packet_pipe_tag))


void scm2text(SCM s_name, text &t)
{
  //SCM_ASSERT(SCM_NIMP(s_name) && SCM_ROSTRINGP(s_name), s_name, SCM_ARG2, 
  //"scm2text");  
  t.init(SCM_ROCHARS(s_name));
}

SCM text2scm(const text &t) 
{
  return gh_str2scm(t.data(), t.length());
}

SCM take_text(text &t)
{
  SCM str = scm_take_str(t.data(), t.length());
  t.reset();
  return str;
}
#endif
