/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/unistd.h>
	   }

#include "fdpipeinputcomponent.h"
#include <libpandora/packet.h>
#include <libpandora/pktutil.h>

component_export(FdPipeInputComponent, Packet, Packet);

bool FdPipeInputComponent::add(Packet *pkt) 
{
  mx.lock();
  if (!doStop) packet_send(pkt, fout, wbuf, sizeof(wbuf));
  mx.unlock();

  cleanPacket(pkt);
  return false;
}

int FdPipeInputComponent::init(void)
{
  doStop = false;
  if (pipe(fdpipe) < 0) {
    pandora_pwarning("pipe");
    return ERROR_FILENO;
  }

  fin = fdopen(fdpipe[0], "r");
  fout = fdopen(fdpipe[1], "w");
  if ((fin == NULL) | (fout == NULL)) {
    pandora_pwarning("fdopen");
    finish();
    return ERROR_FILENO;
  }

  return fdpipe[0];
}

bool FdPipeInputComponent::process(void) 
{
  Packet *pkt = NULL;
  packet_recv(pkt, fin, rbuf, sizeof(rbuf));
  if (pkt == NULL) return true;
  push(pkt);
  return doStop;
}

void FdPipeInputComponent::finish(void) 
{
  mx.lock();
  doStop = true;

  if (fin != NULL) {
    fclose(fin);
    fin = NULL;
  }
  
  if (fout != NULL) {
    fclose(fout);
    fout = NULL;
  }
  mx.unlock();
}

void FdPipeInputComponent::halt(void)
{
  mx.lock();
  doStop = true;

  long s = 0;
  write(fdpipe[1], (char *)&s, 4);
  mx.unlock();
}
