/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef DEMUX_COMPONENT_H
#define DEMUX_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <assert.h>
	   }

#include <libpandora/demap.h>
#include <libpandora/component.h>
#include <libpandora/common_options.h>
#include <libpandora/pandorakey.h>

class DemuxComponent : public Component {
private:
  typedef bool (*dmx_func_t)(Packet *, PandoraKey *);
  typedef DEMap<PandoraKey, int> KeyMap;

  const static PandoraKey _undef_;
  KeyMap kmap;
  PandoraKey key;
  dmx_func_t func;
  int idx;


public:
  component_init(DemuxComponent, 1);
  inline  DemuxComponent(void);
  virtual ~DemuxComponent(void);

  virtual bool add(Packet *pkt);
  virtual bool notify(Component *c);
};

DemuxComponent::DemuxComponent(void) 
  : func(NULL), idx(0) 
{ 
  registerComplexOption(symbol_option, "algo", &func); 
}

#endif /* DEMUX_COMPONENT_H */

