/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <pandora_components/controlpacket.h>
#include <libpandora/timeval.h>
#include <libpandora/serialize.h>

packet_export(ControlPacket,);

ControlPacket::ControlPacket(controlt_t o)
  : opcode(o), data(8000)
{
  setTimeStamp();
}

ControlPacket::ControlPacket(const ControlPacket& x) 
  : Packet(x), opcode(x.opcode), data(x.data)
{
}

ControlPacket& ControlPacket::operator= (const ControlPacket& x) 
{
  Packet::operator=(x); opcode = x.opcode; data = x.data;
  return *this;
}

void ControlPacket::print(ostream *f) 
{
  *f << timeStamp << '\t' << "[control] ";
  *f << "code: #" << (int)opcode << " ";
  *f  << endl;
}

size_t ControlPacket::write(char *str, size_t maxlen, int)
{
  size_t count = 0;

  serialVar(opcode);
  serialVar(data);

  return count;
}

size_t ControlPacket::read(const char *str, int)
{
  size_t count = 0;

  unserialVar(opcode);
  unserialVar(data);

  return count;
}
