/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef CONTROL_COMPONENT_H
#define CONTROL_COMPONENT_H

#include <libpandora/global.h>

#include <iostream>
#include <libpandora/outputcomponent.h>

class ControlPacket;

class ControlComponent : public OutputComponent {
private:
  ControlPacket *resp;

public:

  component_init(ControlComponent, 1);
  ControlComponent(void) : resp(NULL) { }
  virtual ~ControlComponent(void) { }

  virtual bool add(Packet *);
  virtual void cleanup(void);

private: 
  ControlPacket *response(void);
  void sendResponse(void);

  bool start_stack(ControlPacket *);    
  bool stop_stack(ControlPacket *);     
  bool suspend_stack(ControlPacket *);    
  bool resume_stack(ControlPacket *);     
  bool clean(ControlPacket *);
  bool quit(ControlPacket *);
  bool set_stack(ControlPacket *);      
  bool get_stack(ControlPacket *);      
  bool get_stack_name(ControlPacket *);      
  bool list_defined(ControlPacket *);   
  bool list_running(ControlPacket *);   
  bool comp_query(ControlPacket *);      
  bool get_option(ControlPacket *);      
  bool get_option_def(ControlPacket *);      
  bool set_option(ControlPacket *);     
  bool set_option_live(ControlPacket *);     
  bool list_options(ControlPacket *);      
  bool set_lib(ControlPacket *); 
  bool get_lib(ControlPacket *); 
  bool list_libs(ControlPacket *); 
  bool set_binding(ControlPacket *); 
  bool get_binding(ControlPacket *); 
  bool list_symbols(ControlPacket *); 
  bool comp_alive(ControlPacket *);
  bool packet_alive(ControlPacket *);
  bool add_res(ControlPacket *);
  bool del_res(ControlPacket *);
  bool set_res_pri(ControlPacket *);
  bool list_res(ControlPacket *);
  bool update_res(ControlPacket *);
};

#endif /* CONTROL_COMPONENT */
