/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

#include <limits.h>
#include <libpandora/stat_functions.h>

extern_pandora(stat, bool, mean, (stat_op_t op, int &val, 
				  int storage[stat_storage_size]))
{
  //storage[0]: value sum
  //storage[1]: count
  switch (op) {
  case stat_init:	storage[0] = storage[1] = 0; 
    return true;

  case stat_update:	storage[0] += val; ++storage[1]; 
    return true;

  case stat_finish:	val = ((storage[1] > 0) ? storage[0]/storage[1] : 0);
    return (storage[1] > 0);

  default:		break;
  }

  return false;
}

extern_pandora(stat, bool, last, (stat_op_t op, int &val, 
				 int storage[stat_storage_size]))
{
  // storage[0]: last value
  switch (op) {
  case stat_init:	
    return true;

  case stat_update:	storage[0] = val; 
    return true;

  case stat_finish:	val = storage[0]; 
    return true;

  default:		break;
  }

  return false;
}

extern_pandora(stat, bool, max, (stat_op_t op, int &val, 
				int storage[stat_storage_size]))
{
  // storage[0]: max value
  switch (op) {
  case stat_init:	storage[0] = INT_MIN; 
    return true;

  case stat_update:	if (val > storage[0]) storage[0] = val; 
    return true;

  case stat_finish:	val = storage[0]; 
    return true;

  default:		break;
  }

  return false;
}

extern_pandora(stat, bool, min, (stat_op_t op, int &val, 
				int storage[stat_storage_size]))
{
  // storage[0]: min value
  switch (op) {
  case stat_init:	storage[0] = INT_MAX; 
    return true;

  case stat_update:	if (val < storage[0]) storage[0] = val; 
    return true;

  case stat_finish:	val = storage[0]; 
    return true;

  default:		break;
  }

  return false;
}

extern_pandora(stat, bool, sum, (stat_op_t op, int &val, 
				int storage[stat_storage_size]))
{
  // storage[0]: sum
  switch (op) {
  case stat_init:	storage[0] = 0; 
    return true;

  case stat_update:	storage[0] += val; 
    return true;

  case stat_finish:	val = storage[0]; 
    return true;

  default:		break;
  }

  return false;
}

extern_pandora(stat, bool, count_test, (stat_op_t op, int &val, 
				   int storage[stat_storage_size]))
{
  // storage[0]: counter
  switch (op) {
  case stat_init:	storage[0] = 0; 
    return true;

  case stat_update:	++storage[0]; 
    return true;

  case stat_finish:	val = storage[0]; 
    return true;

  default:		break;
  }

  return false;
}

