/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <pandora_components/cctrl.h>

void cctrl_t::parse(const char *cstr) 
{
  cstr = skip_ws((char *)cstr);
  while (cstr != NULL){
    parse_1(cstr);
    cstr = next_field(cstr);
  } 
}

void cctrl_t::print(void) 
{
  cout << "{ ";
  if (no_cache > 0)		cout << "no-cache ";
  if (no_store > 0)		cout << "no-store " ;
  if (no_transform > 0)	cout << "no-transform " ;
  if (only_if_cached > 0)	cout << "only-if-cached ";
  if (_public > 0)		cout << "public ";
  if (_private > 0)		cout << "private ";
  if (must_revalidate > 0)	cout << "must-revalidate ";
  if (proxy_revalidate > 0)	cout << "proxy-revalidate ";
  if (max_age >= 0)		cout << "max-age=" << max_age << ' ';
  if (s_max_age >= 0)		cout << "s-max-age=" << s_max_age << ' ';
  if (max_stale >= 0)		cout << "max-stale=" << max_stale << ' ';
  if (min_fresh >= 0)		cout << "min-fresh=" << min_fresh << ' ';
  cout << "} ";
}

void cctrl_t::assign(int &lv, const char *cstr)
{
  char *s1, *s2;
  s1=strchr(cstr, ',');
  s2=strchr(cstr, '=');
  if ((s2 == NULL) || ((s1 != NULL) && (s2 > s1))) return;
  else lv = atoi(skip_ws(s2+1));
}


void cctrl_t::parse_1(const char *cstr) 
{
  if (!strncmp(cstr, "no-cache",	8))	no_cache=1;
  if (!strncmp(cstr, "no-store",	8))	no_store=1;
  if (!strncmp(cstr, "no-transform",	12))	no_transform=1;
  if (!strncmp(cstr, "only-if-cached",	14))	only_if_cached=1;
  if (!strncmp(cstr, "public",		6))	_public=1;
  if (!strncmp(cstr, "private",		7))	_private=1;
  if (!strncmp(cstr, "must-revalidate",	15))	must_revalidate=1;
  if (!strncmp(cstr, "proxy-revalidate",16))	proxy_revalidate=1;
  if (!strncmp(cstr, "max-age",		7))	assign(max_age, cstr);
  if (!strncmp(cstr, "s-max-age",	9))	assign(s_max_age, cstr);
  if (!strncmp(cstr, "max-stale",	9))	assign(max_stale, cstr);
  if (!strncmp(cstr, "min-fresh",	9))	assign(min_fresh, cstr);  
}


void etag_t::parse(const char *str) 
{
  if (str == NULL) return;
  size_t len = strlen(str);
  if (len < 2) return;
  char *tmp = NULL;
  if (!strncmp(str, "W/", 2)) {
    weak = true;
    str += 2;
  }
  if (*str != '"') goto error;
  ++str;
  tmp = strchr(str, '"');
  if (tmp == NULL) goto error;
  tag.init(str, tmp-str);
  return;

 error:
  pandora_warning("ignoring malformed ETag");
  return;
}

void etag_t::print(void) 
{
  if (tag.isNull()) {
    cout << "- ";
    return ;
  } else {
    if (weak) cout << "W/";
    cout << '"' << tag << '"' << ' ';
  }
}
