/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef CACHE_MATCH_COMPONENT_H
#define CACHE_MATCH_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <sys/socket.h>
}

#include <list>
#include <pandora_components/cachetranspacket.h>
#include <pandora_components/httptranspacket.h>
#include <libpandora/component.h>

class CacheMatchComponent : public Component {
public:
  typedef list<HTTPTransPacket*> req_list_t;

private:
  HTTPTransPacket	*cache;
  req_list_t 		rlist[2];
  int 			cto;
  bool 			check;

public:
  component_init(CacheMatchComponent, 1);
  CacheMatchComponent(void);
  virtual ~CacheMatchComponent(void) {}

  virtual bool add(Packet*);
  virtual void cleanup(void);
  virtual bool prepare(void);

private:
  void flush(req_list_t *);
  void setCacheRequest(HTTPTransPacket *);
  void flushCacheRequest(void);
  bool findMatch(HTTPTransPacket *httptp, req_list_t *l, bool b);
};

#endif /* CACHE_MATCH_COMPONENT_H */
