/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef CACHE_EVAL_COMPONENT_H
#define CACHE_EVAL_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
	   }

#include <libpandora/component.h>
#include <pandora_components/cacheevalpacket.h>
#include <libpandora/queue.h>

class CacheEvalComponent : public Component {
private:
  CacheEvalPacket global, temp;
  float coeff_rtt, coeff_lat, coeff_bytes, 
    coeff_coop, coeff_stale;
  int mem, avg;
  Queue<CacheEvalPacket> Q;
  time_t firstTime, target;
  bool abstime;
  int offset;
  double result;

public:
  component_init(CacheEvalComponent, 1);
  CacheEvalComponent(void) ;
  virtual ~CacheEvalComponent(void) {}

  virtual bool add(Packet *);
  virtual void cleanup(void) { update(); }

protected:
  virtual double eval(CacheEvalPacket &);
  void update(void);
};

#endif /* CACHE_EVAL_COMPONENT_H */
