/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef AGGREGATE_COMPONENT_H
#define AGGREGATE_COMPONENT_H

#include <libpandora/global.h>

#include <iostream>
#include <libpandora/map.h>
#include <pandora_components/rpctranspacket.h>

#include <libpandora/component.h>

struct ServerStat {
  u_long count, rtt;
  ServerStat() : count(0), rtt(0) {}
};

class AggregateComponent : public Component {
private:
  Map<u_int32_t, ServerStat*> smap;

  u_long count;
  u_long missed;
  u_long rtt;
  u_int32_t server;
  time_t start, end;

  int interval;

public:

  component_init(AggregateComponent, 1);
  AggregateComponent(void) : count(0), missed(0), rtt(0), server(0), start(0),
    end(0), interval(1) {
    registerOption("interval", &interval);
  }

  virtual ~AggregateComponent(void) {    
    Association<u_int32_t, ServerStat*> assoc;
    elementsDo(smap, assoc) __DELETE(assoc.value);
  }  

  virtual bool add(Packet *p);
  void display(void);
  virtual void cleanup(void);
};

#endif /* AGGREGATE_COMPONENT_H */
