/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>
#include <libpandora/algo_funcs.h>
#include <libpandora/packet.h>
#include <libpandora/component.h>

#include <pandora_components/ippacket.h>
#include <pandora_components/icptranspacket.h>
#include <pandora_components/cachetranspacket.h>
#include <pandora_components/httppacket.h>
#include <pandora_components/httptranspacket.h>
#include <pandora_components/valuepacket.h>

extern_pandora(action, bool, iplen, (Packet *pkt, Component *context))
{
  locatePacket0(IPPacket, ipp, pkt);
  if (ipp == NULL) {
    cleanPacket(pkt);
    return false;
  }

  IntValuePacket *vp = new IntValuePacket(ipp->length, ipp->timeStamp);
  cleanPacket(pkt);
  context->push(vp);
  return true;
}

extern_pandora(action, bool, staledocs, (Packet *pkt, Component *context))
{
  time_t req_time = 0;
  locatePacket0(CacheTransPacket, ctp, pkt);
  locatePacket(HTTPPacket, htp, ctp);
  if (htp == NULL) goto clean;
  if ((ctp->p_lm <= 0) || (htp->lm <= 0)) goto clean;
  if (ctp->p_lm == htp->lm) goto clean;
  
  req_time = (pkt->timeStamp).tv_sec;
  if (ctp->p_lm < htp->lm) cout <<       "error:   ";
  else if (req_time < ctp->p_lm) cout << "unknown: ";
  else cout <<                           "stale:   ";
  cout <<  htp->lm  << " / " << ctp->p_lm << " / " << req_time << "\n";
  
  context->push(pkt);
  return true;

clean:
  cleanPacket(pkt);
return true;      
}

extern_pandora(action, bool, cleanme, (Packet *pkt, Component *context))
{
  pandora_warning("test");
  cleanPacket(pkt);
  return true;
}

extern_pandora(eval, bool, cache, (int *val, Packet *pkt, 
				   int *params, int nbparams))
{ 
  const static int res = 1000;
  //params[0]: rtt weight
  //params[1]: bytes weight
  if (nbparams < 2) return false;
  if ((params[0] + params[1]) == 0) return false;

  locatePacket0(CacheTransPacket, ctp, pkt);
  locatePacket(HTTPTransPacket,	htp,	ctp);
  if (htp == NULL) return false;
  
  *val = (((params[0] * ((res * ctp->rtt_saved) / htp->rtt)) 
	   + (params[1] * ((res * ctp->bytes_saved) 
			   / (htp->reqhlen + htp->reqmlen
			      + htp->resphlen + htp->respmlen))))
	  / (params[0] + params[1]));

  return true;
}

extern_pandora(eval, bool, icp, (int *val, Packet *pkt, 
				 int *params, int nbparams))
{  
  if (nbparams < 2) return false;
  locatePacket0(ICPTransPacket, itp, pkt);
  if (itp == NULL) return false;
  
  *val = 2;
  return true;
}

extern_pandora(eval, bool, evaltest, (int *val, Packet *pkt, 
				      int *params, int nbparams))
{
  static int num = 0;

  locatePacket0(IntValuePacket, ivp, pkt);
  if (ivp == NULL) return false;

#if 0
  CERR(LOG_DEBUG) << "params: ";
  for (int i = 0; i < nbparams; ++i) {
    cerr << params[i] << " ";
  }
  cerr << endl;
#endif

  *val = 1;
  return true;
}

extern_pandora(action, bool, bytessum, (Packet *pkt, Component *context))
{
  locatePacket(HTTPTransPacket, htp, pkt);
  if (htp == NULL) {
    cleanPacket(pkt);
    return false;
  }
  
  int  cbytes = (htp->reqhlen + htp->reqmlen
		 + htp->resphlen + htp->respmlen);

  pandora_info(cbytes);
  
  cleanPacket(pkt);
  return true;
}
