/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __TYPES_H
#define __TYPES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>

#ifdef HAVE_SYS_BITYPES_H
#include <sys/bitypes.h>
#endif

#ifndef HAVE_U_INT8_T

#if SIZEOF_CHAR == 1
typedef unsigned char u_int8_t;
#elif SIZEOF_INT == 1
typedef unsigned int u_int8_t;
#else  /* XXX */
typedef unsigned char u_int8_t;
#endif

#endif /* HAVE_U_INT8_T */

#ifndef HAVE_U_INT16_T

#if SIZEOF_SHORT == 2
typedef unsigned short u_int16_t;
#elif SIZEOF_INT == 2
typedef unsigned int u_int16_t;
#elif SIZEOF_CHAR == 2
typedef unsigned char u_int16_t;
#else  /* XXX */
typedef unsigned short u_int16_t;
#endif

#endif /* HAVE_U_INT16_T */


#ifndef HAVE_U_INT32_T

#if SIZEOF_INT == 4
typedef unsigned int u_int32_t;
#elif SIZEOF_LONG == 4
typedef unsigned long u_int32_t;
#elif SIZEOF_SHORT == 4
typedef unsigned short u_int32_t;
#else  /* XXX */
typedef unsigned int u_int32_t;
#endif

#endif /* HAVE_U_INT32_T */

#ifndef HAVE_INT32_T

#if SIZEOF_INT == 4
typedef int int32_t;
#elif SIZEOF_LONG == 4
typedef long int32_t;
#elif SIZEOF_SHORT == 4
typedef short int32_t;
#else  /* XXX */
typedef int int32_t;
#endif

#endif /* HAVE_INT32_T */

#ifndef HAVE_IN_ADDR_T
typedef u_int32_t in_addr_t;
#endif

#ifndef HAVE_SOCKLEN_T
typedef int socklen_t;
#endif

typedef int32_t symbol_id_t;

typedef unsigned long stack_handle_t;
#define NIL_STACK_HANDLE ((stack_handle_t) 0)

#endif /* __TYPES_H */





