/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/thread.h>

void *thread_run(void *thr)
{
  ((Thread *)thr)->main();
  return 0;
}

Thread &Thread::run(void) 
{
#ifdef _NOTHREADS
  pandora_error("threads required but not enabled!");
#else
  pandora_assert(thread == 0);
  
  PTHREAD(create,(&thread, 0, thread_run, (void *)this));
  //pandora_debug("thread #" << (int)thread << " started");
  //PTHREAD(setcancelstate, (PTHREAD_CANCEL_ENABLE, NULL));
  //PTHREAD(setcanceltype, (PTHREAD_CANCEL_ASYNCHRONOUS, NULL));
#endif

  return *this;
}

Thread &Thread::detach(void) 
{
  pandora_assert(thread != 0);
  PTHREAD(detach,(thread));
  return *this;
}

Thread &Thread::join(void) 
{
  pandora_assert(thread != 0);
  PTHREAD(join,(thread, 0));
  thread = 0;
  return *this;
}

Thread &Thread::cancel(void) 
{
  pandora_assert(thread != 0);
  PTHREAD(cancel,(thread));
  //pandora_debug("thread #" << (int)thread << " cancelled");
  return *this;
}

