/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef STRING_KEY_H
#define STRING_KEY_H

#include <libpandora/global.h>
#include <libpandora/dmxkey.h>
#include <libpandora/text.h>

class StringKey : public DmxKey {
private:
  text str;
  key_init(StringKey);

public:
  inline StringKey(void);
  inline StringKey(const text &s);
  inline StringKey(const char *s);
  inline StringKey(const char *s, int l);
  inline StringKey(const StringKey& x);
  virtual ~StringKey(void);

  inline void set(const text &s);
  inline void set(const char *s);
  inline void set(const char *s, int l);
  inline long hash(void) const;

private:
  bool _equal(const DmxKey *x) const;
};

StringKey::StringKey(void) 
{ 
}

StringKey::StringKey(const text &t)
  : str(t)
{ 
}

StringKey::StringKey(const char *s)
  : str(s)
{ 
}

StringKey::StringKey(const char *s, int l)
  : str(s, l)
{ 
}

long StringKey::hash(void) const 
{ 
  return (long)str;
}

void StringKey::set(const text &t) 
{
  str.init(t);
}

void StringKey::set(const char *s) 
{
  str.init(s);
}

void StringKey::set(const char *s, int l) 
{
  str.init(s, l);
}

bool StringKey::_equal(const DmxKey *_x) const
{
  const StringKey *x = (const StringKey *)_x;
  return (str == x->str);
}

#endif /* STRING_KEY_H */
