/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef STORAGE_H
#define STORAGE_H

#include <libpandora/global.h>

#include <libpandora/conf/time.h>
#include <libpandora/text.h>
#include <libpandora/fileutil.h>
#include <libpandora/datalog.h>

class StackEntry;
class DynLibrary;
class DynSymbol;

class Storage {
public:
  enum storage_type_t { undefined = -1, state, stack, library, symbol };

private:
  char dir[PATH_MAX];
  char buf[8192];
  DataLog stacks, libconfig;

public: 
  Storage(void);
  ~Storage(void);

  bool init(const char *name = NULL);

  bool save(storage_type_t type, const text &key, void *data);
  bool store(const text &key, const void *data, int length)   { return false; }

private:
  bool save_stack (const text&, StackEntry *);
  bool save_lib   (const text&, DynLibrary *);
  bool save_symbol(const text&, DynSymbol  *);
};

extern Storage *storage;

#endif /* STORAGE_H */
