/* Copyright (C) 1999, 2000, 2001, 2002 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#ifdef USE_SSL

#include <libpandora/error.h>
#include <libpandora/sslutil.h>

#include <openssl/err.h>

SSL_CTX *ssl_init(const char *cert)
{
  SSL_load_error_strings();
  SSL_library_init();

  SSL_METHOD *method = SSLv23_method();
  SSL_CTX *ctx = SSL_CTX_new(method);

  if (ctx == NULL) {
    pandora_warning("cannot create SSL context");
    goto err;
  }

  SSL_CTX_set_verify_depth(ctx, 1);
  SSL_CTX_set_verify(ctx, SSL_VERIFY_PEER, NULL);

#if 0
  if (SSL_CTX_load_verify_locations(ctx, calist, NULL) <= 0) {
    pandora_warning("cannot load certificate file: " << calist);
    goto err;
  }
#endif

  if (SSL_CTX_use_certificate_file(ctx, cert, SSL_FILETYPE_PEM) != 1) {
    pandora_warning("cannot load certificate file: " << cert);
    goto err;
  }

  if (SSL_CTX_use_PrivateKey_file(ctx, cert, SSL_FILETYPE_PEM) != 1){
    pandora_warning("cannot load private key file: " << cert);
    goto err;
  }
        
  if (SSL_CTX_check_private_key(ctx) != 1) {
    pandora_warning("private key does not match certificate public key");
    goto err;
  }

  return ctx;

 err:
  ssl_fini(ctx);
  return NULL;
}

void ssl_fini(SSL_CTX *ctx)
{
  ERR_print_errors_fp(stderr);
  if (ctx != NULL) SSL_CTX_free(ctx);
  ERR_free_strings();
}

#endif /* USE_SSL */
