/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef SS_BMH_H
#define SS_BMH_H

#include <libpandora/global.h> 

typedef unsigned shift_int ;

struct bmh_header
{
	shift_int *shift ;
} ;

struct ss_header
{
  char 				*ss_pattern ;
  int				ss_patlen ;
  struct bmh_header 		bmhh ;
} ;

typedef struct ss_header header_s ;

#define HP( p )						((header_s *)(p))

/*
 * Structure field access
 */
#define SS_PATTERN( hp )				(hp)->ss_pattern
#define SS_PATLEN( hp )					(hp)->ss_patlen
#define BMH_HEADER( hp )				(&(hp)->bmhh)


#ifndef NULL
#define NULL						0
#endif

#ifndef FALSE
#define FALSE						0
#define TRUE						1
#endif

#define CHAR_NULL					((char *)0)
#define PRIVATE						static

/*
 * NBIC is the Number-of-Bits-In-a-Char
 */
#ifndef NBIC
#define NBIC						8
#endif

#define ALPHABET_SIZE					( 1 << NBIC )

/*
 * Return values
 */
#define SS_OK						0
#define SS_ERR						(-1)

int bmh_setup(header_s *, char *, int) ;
char *bmh_match(header_s*, char *, int) ;
void bmh_done(header_s *) ;

#endif	/* SS_BMH_H */

