/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h> 

#include <stdlib.h>
#include <libpandora/conf/string.h>

#include <libpandora/ss_bmh.h>


int bmh_setup(register header_s * hp, register char *pattern,
	      register int patlen )
{
  register int limit = patlen - 1 ;			/* patlen is > 0 */
  register int i ;
  shift_int *shift ;

  SS_PATTERN( hp ) = xstrdup(pattern) ;
  SS_PATLEN( hp ) = patlen ;
  
  shift = (shift_int *) xmalloc( ALPHABET_SIZE * sizeof( shift_int ) ) ;
  if ( shift == (shift_int *)NULL )
    return( SS_ERR ) ;

  for ( i = 0 ; i < ALPHABET_SIZE ; i++ )
    shift[ i ] = patlen ;
	
  for ( i = 0 ; i < limit ; i++ )
    shift[ (unsigned char) pattern[ i ] ] = limit - i ;

  BMH_HEADER( hp )->shift = shift ;
  return( SS_OK ) ;
}


char *bmh_match(register header_s *hp, register char *str, int len )
{
  register int i ;
  int patlen = SS_PATLEN( hp ) ;
  char *pattern = SS_PATTERN( hp ) ;
  register char lpc = pattern[ patlen-1 ] ;	  /* last pattern character */
  shift_int *shift = BMH_HEADER( hp )->shift ;

  i = patlen - 1 ;
  while ( i < len ) {
    char c = str[ i ] ;

    if ( c == lpc ) {
      int j, k ;

      for ( j = patlen-1, k = i ;; ) {
	if ( j == 0 ) return( &str[ k ] ) ;
	j--, k-- ;
	if ( pattern[ j ] != str[ k ] ) break ;
      }
    }
    i += shift[ (unsigned char) c ] ;
  }
  return( CHAR_NULL ) ;
}


void bmh_done( header_s *hp )
{
	(void) xfree( (char *)BMH_HEADER( hp )->shift ) ;
	(void) xfree( (char *)SS_PATTERN( hp ) ) ;
}

