/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SOCKET_SELECT_H
#define SOCKET_SELECT_H

#include <libpandora/global.h>

#include <libpandora/netselect.h>
#include <libpandora/error.h>

class SocketSelect : public NetSelect {
public:
  typedef bool net_func_t(int, void *);

private:
  bool		inet;
  bool 		connected;

public:
  inline SocketSelect(bool in, bool stream);
  virtual ~SocketSelect(void) 		{ }

private:
  static bool incomming(int fd, void *me);
  static bool nc(int fd, void *me);
  static void ec(int fd, void *me);
};


SocketSelect::SocketSelect(bool in, bool stream) 
  : inet(in), connected(stream)
{
  infun = (stream ? &incomming : &nc);
  outfun = &ec;
}

#endif /* SOCKET_SELECT_H */
