/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SINGLE_KEY_H
#define SINGLE_KEY_H

#include <libpandora/global.h>
#include <libpandora/dmxkey.h>

class SingleKey : public DmxKey {
private:
  long k1;
  key_init(SingleKey);

public:
  inline SingleKey(void);
  inline SingleKey(long r);
  virtual ~SingleKey(void) { }

  inline void set(long xk1);
  inline long hash(void) const;

private:
  inline bool _equal(const DmxKey *x) const;
};

SingleKey::SingleKey(void) 
  : k1(0) 
{
}

SingleKey::SingleKey(long r) 
  : k1(r) 
{ 
}

void SingleKey::set(long xk1) 
{ 
  k1 = xk1; 
}
  
long SingleKey::hash(void) const 
{ 
  return k1; 
}

bool SingleKey::_equal(const DmxKey *_x) const 
{ 
  const SingleKey *x = (const SingleKey *)_x;
  return (k1 == x->k1); 
}

#endif /* SINGLE_KEY_H */
