/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/server.h>
#include <libpandora/netutil.h>
#include <libpandora/socketselect.h>

Server::~Server(void)
{
  __DELETE(sel); 
}

bool Server::init(NetSelect::net_func_t *func, void *data, 
		  int port, bool inet, bool stream) 
{ 
  int fd = openserver(port, inet, stream);
  if (fd < 0) return false;
  pandora_info("listening on port " 
	       << (inet ? "inet:" : "unix:")
	       << (stream ? "tcp/" : "udp/")
	       << port );
  sel = new SocketSelect(inet, stream);
  bool status = sel->setup(fd, func, data);
  if (!status) pandora_warning("failed netselect setup");
  return status;
}

