/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef RESOURCE_MANAGER_H
#define RESOURCE_MANAGER_H

#include <libpandora/global.h>

#include <map>
#include <libpandora/map.h>
#include <libpandora/text.h>

class resource_t;
class resource_entry_t;

class ResourceManager {
private:
  typedef bool (*action_t)(const char *, void *);
  typedef pair<int, long> 		elt_t;
  typedef multimap<int, long>::iterator map_iter_t;

  multimap<int, long>			order;
  Map<long, resource_t *> 		resources;
  action_t action;
  void *data;
  
public:
  ResourceManager(void) : action(NULL), data(NULL) { }
  inline ResourceManager(action_t a, void *d = NULL);
  ~ResourceManager(void);

  inline void setAction(action_t a, void *d = NULL) { action = a; data = d; }

  bool addResource(const text &, int pri);
  bool setPriority(const text &, int pri);
  bool deleteResource(const text &);
  int  listResources(resource_entry_t *re, int max_res);

  bool update(void);
  bool check(const text &);

private:
  bool check(resource_t *);
};

ResourceManager::ResourceManager(action_t a, void *d) 
  : action(a), data(d) 
{ 
}

#endif /* RESOURCE_MANAGER_H */
